<?php

declare(strict_types=1);

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            // 'department_id'     => 'required|exists:departments,id',
            // 'sub_department_id' => 'required|exists:departments,id',
            // 'emp_code'          => 'required|max:15|unique:app_users,emp_code|regex:/^[A-Z0-9]+$/',
            // 'dob'               => 'required',
            // 'gender'            => ['required', Rule::in(['m', 'f', 'o'])],
            // 'ward_id'           => 'required',
            // 'role'              => 'required',
            'name'              => 'required|string|max:150',
            'email'             => 'required|unique:users,email|email',
            'mobile'            => 'required|unique:users,mobile|digits:10',
            'password'          => 'required|min:8',
            'confirm_password'  => 'required|same:password',
        ];
    }
}
