<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceDetail extends BaseModel
{
    protected $fillable = [
        'booking_for_id',
        'name',
        'category',
        'location',
        'rating',
        'icon',
        'availability',
        'capacity',
        'area_size',
        'cost',
        'image',
        // Pool specific
        'water_temp',
        'depth_range',
    ];

    protected $casts = [
        'rating' => 'decimal:1',
        'water_temp' => 'decimal:1',
    ];

    /**
     * Get the booking for (service type) that this detail belongs to.
     */
    public function bookingFor()
    {
        return $this->belongsTo(BookingFor::class);
    }

    /**
     * Check if this is a turf service.
     */
    public function isTurf(): bool
    {
        return stripos($this->bookingFor?->service ?? '', 'turf') !== false;
    }

    /**
     * Check if this is a pool service.
     */
    public function isPool(): bool
    {
        return stripos($this->bookingFor?->service ?? '', 'pool') !== false;
    }
}
