<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SpecialBookingSlot extends BaseModel
{
    protected $fillable = [
        'booking_for_id',
        'date',
        'time',
        'price'
    ];

    protected $casts = [
        'date' => 'date:Y-m-d',
        'time' => 'datetime:H:i',
    ];

    public function bookingFor()
    {
        return $this->belongsTo(BookingFor::class);
    }
}
