<?php

declare(strict_types=1);

namespace Database\Seeders;

use App\Models\Tenant;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class DefaultLoginUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // $tenant = Tenant::updateOrCreate(['id' => 1], ['name' => 'Forren']);

        // Super Admin Seeder
        $adminRole   = Role::updateOrCreate(['name' => 'Super Admin']);
        $permissions = Permission::pluck('id')->toArray();
        $adminRole->syncPermissions($permissions);

        $admin = User::updateOrCreate([
            'email' => 'superadmin@gmail.com',
        ], [
            'name'      => 'Admin',
            'email'     => 'superadmin@gmail.com',
            'mobile'    => '9999999991',
            'password'  => Hash::make('password'),
        ]);
        DB::table('model_has_roles')->updateOrInsert([
            'model_type' => 'App\Models\User',
            'model_id'   => $admin->id,
        ], [
            'role_id' => $adminRole->id,
        ]);

        // Admin Seeder
        $adminRole   = Role::updateOrCreate(['name' => 'Admin']);
        $permissions = Permission::pluck('id')->toArray();
        $adminRole->syncPermissions($permissions);

        $admin = User::updateOrCreate([
            'email' => 'admin@gmail.com',
        ], [
            'name'      => 'Admin',
            // 'tenant_id' => $tenant->id,
            'email'     => 'admin@gmail.com',
            'mobile'    => '9999999992',
            'password'  => Hash::make('12345678'),
        ]);
        DB::table('model_has_roles')->updateOrInsert([
            'model_type' => 'App\Models\User',
            'model_id'   => $admin->id,
        ], [
            'role_id' => $adminRole->id,
        ]);

        // Test User Seeder
        $userRole    = Role::updateOrCreate(['name' => 'User']);
        $permissions = Permission::pluck('id')->toArray();
        $userRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'testuser1@gmail.com',
        ], [
            'name'      => 'Test User1',
            // 'tenant_id' => $tenant->id,
            'email'     => 'testuser1@gmail.com',
            'mobile'    => '9999999993',
            'password'  => Hash::make('12345678'),
        ]);
        DB::table('model_has_roles')->updateOrInsert([
            'model_type' => 'App\Models\User',
            'model_id'   => $user->id,
        ], [
            'role_id' => $userRole->id,
        ]);
    }
}
