<x-admin.admin-layout>
    <x-slot name="title">Dashboard</x-slot>

    @push('styles')
    <style>
        :root {
            --soft-bg: #f3f4f6;
            --soft-surface: #ffffff;
            --soft-shadow-light: -6px -6px 12px rgba(255, 255, 255, 0.8);
            --soft-shadow-dark: 6px 6px 12px rgba(163, 177, 198, 0.2);
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --radius-md: 16px;
            --radius-sm: 12px;
        }

        body.dark-only {
            --soft-bg: #1f2937;
            --soft-surface: #111827;
            --soft-shadow-light: -4px -4px 10px rgba(55, 65, 81, 0.5);
            --soft-shadow-dark: 4px 4px 10px rgba(0, 0, 0, 0.5);
        }

        .dashboard-default-sec { background-color: var(--soft-bg); padding-bottom: 30px; }

        /* Soft UI Cards */
        .card-soft {
            background: var(--soft-surface);
            border-radius: var(--radius-md);
            box-shadow: var(--soft-shadow-dark), var(--soft-shadow-light);
            border: none;
            transition: all 0.3s ease;
            margin-bottom: 20px;
        }
        .card-soft:hover { transform: translateY(-3px); box-shadow: 8px 8px 16px rgba(163, 177, 198, 0.25), -8px -8px 16px rgba(255, 255, 255, 0.9); }
        
        .card-header-soft {
            background: transparent;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            padding: 15px 20px;
            font-weight: 600;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        /* Compact Metrics */
        .metric-value { font-size: 1.5rem; font-weight: 700; color: #374151; }
        .metric-label { font-size: 0.85rem; color: #6b7280; font-weight: 500; }
        .trend-badge { padding: 4px 8px; border-radius: 8px; font-size: 0.75rem; font-weight: 600; display: inline-flex; align-items: center; }
        .trend-up { background: rgba(16, 185, 129, 0.1); color: #10b981; }
        .trend-down { background: rgba(239, 68, 68, 0.1); color: #ef4444; }

        /* Icon Shapes */
        .icon-shape {
            width: 42px; height: 42px;
            border-radius: 12px;
            display: flex; align-items: center; justify-content: center;
            font-size: 1.2rem;
            box-shadow: inset 3px 3px 6px rgba(0,0,0,0.1), inset -3px -3px 6px rgba(255,255,255,0.7);
        }
        .icon-primary { background: #eff6ff; color: #3b82f6; }
        .icon-success { background: #f0fdf4; color: #22c55e; }
        .icon-warning { background: #fefce8; color: #eab308; }
        .icon-danger { background: #fef2f2; color: #ef4444; }

        /* Quick Actions */
        .btn-quick {
            display: flex; flex-direction: column; align-items: center; justify-content: center;
            padding: 15px; border-radius: var(--radius-sm);
            background: var(--soft-surface);
            box-shadow: var(--soft-shadow-dark), var(--soft-shadow-light);
            color: #4b5563; text-decoration: none;
            transition: all 0.2s;
            height: 100%; border: 1px solid transparent;
        }
        .btn-quick:hover { transform: scale(1.02); color: #6366f1; border-color: rgba(99, 102, 241, 0.2); }
        .btn-quick i { font-size: 1.5rem; margin-bottom: 8px; }
        .btn-quick span { font-size: 0.8rem; font-weight: 600; }

        /* Venue Grid */
        .venue-status-item {
            display: flex; align-items: center; justify-content: space-between;
            padding: 10px 15px;
            border-bottom: 1px solid #f3f4f6;
        }
        .venue-status-item:last-child { border-bottom: none; }
        .status-dot { width: 8px; height: 8px; border-radius: 50%; display: inline-block; margin-right: 6px; }
        .status-occupied { background-color: #ef4444; box-shadow: 0 0 8px rgba(239, 68, 68, 0.5); }
        .status-available { background-color: #22c55e; box-shadow: 0 0 8px rgba(34, 197, 94, 0.5); }

        /* Custom Scrollbar for lists */
        .scroll-list { max-height: 250px; overflow-y: auto; }
        .scroll-list::-webkit-scrollbar { width: 5px; }
        .scroll-list::-webkit-scrollbar-thumb { background: #e5e7eb; border-radius: 10px; }

        /* Compact Controls */
        .form-control-soft {
            border-radius: 10px; border: 1px solid #e5e7eb;
            background: var(--soft-surface);
            box-shadow: inset 2px 2px 5px rgba(0,0,0,0.05);
            font-size: 0.85rem;
        }
        
    </style>
    @endpush

    <div class="page-body">
        <div class="container-fluid dashboard-default-sec pt-4">
            
            <!-- Filters & Quick Stats Row -->
            <div class="row mb-3 align-items-center">
                <div class="col-md-5">
                    <h5 class="mb-1 fw-bold text-dark">Dashboard</h5>
                    <p class="text-muted small mb-0">Operational Overview &bull; {{ $startDate->format('M d') }} - {{ $endDate->format('M d') }}</p>
                </div>
                <div class="col-md-7">
                    <form action="{{ route('dashboard') }}" method="GET" class="d-flex justify-content-md-end gap-2 align-items-center">
                        <input type="date" name="start_date" class="form-control form-control-soft" style="width: 130px;" value="{{ $startDate->format('Y-m-d') }}">
                        <span class="text-muted">-</span>
                        <input type="date" name="end_date" class="form-control form-control-soft" style="width: 130px;" value="{{ $endDate->format('Y-m-d') }}">
                        <button type="submit" class="btn btn-primary btn-sm rounded-pill px-3 shadow-sm">Apply</button>
                    </form>
                </div>
            </div>

            <!-- Compact Metrics Grid (4 items) -->
            <div class="row g-3 mb-4">
                <div class="col-xl-3 col-sm-6">
                    <div class="card-soft p-3 d-flex flex-row align-items-center">
                        <div class="icon-shape icon-primary me-3"><i class="fa fa-bookmark"></i></div>
                        <div>
                            <div class="metric-value">{{ number_format($totalBookings) }}</div>
                            <div class="metric-label">Bookings <span class="{{ $bookingGrowth >= 0 ? 'text-success' : 'text-danger' }} small fw-bold">{{ abs(round($bookingGrowth)) }}%</span></div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6">
                    <div class="card-soft p-3 d-flex flex-row align-items-center">
                        <div class="icon-shape icon-success me-3"><i class="fa fa-dollar"></i></div>
                        <div>
                            <div class="metric-value">${{ number_format($totalRevenue) }}</div>
                            <div class="metric-label">Revenue <span class="{{ $revenueGrowth >= 0 ? 'text-success' : 'text-danger' }} small fw-bold">{{ abs(round($revenueGrowth)) }}%</span></div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6">
                    <div class="card-soft p-3 d-flex flex-row align-items-center">
                        <div class="icon-shape icon-warning me-3"><i class="fa fa-futbol-o"></i></div>
                        <div>
                            <div class="metric-value">{{ $activeVenues }}</div>
                            <div class="metric-label">Active Venues</div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6">
                    <div class="card-soft p-3 d-flex flex-row align-items-center">
                        <div class="icon-shape icon-danger me-3"><i class="fa fa-bolt"></i></div>
                        <div>
                            <div class="metric-value">{{ $utilizationRate }}%</div>
                            <div class="metric-label">Utilization</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Content Grid -->
            <div class="row g-3">
                <!-- Left Column (Main Charts) -->
                <div class="col-xl-8 col-lg-7">
                    <!-- Revenue Trend -->
                    <div class="card-soft mb-3">
                        <div class="card-header-soft">
                            <span>Revenue Trend</span>
                            <small class="text-muted">Daily Income</small>
                        </div>
                        <div class="card-body p-3">
                            <div id="revenueChart" style="min-height: 280px;"></div>
                        </div>
                    </div>

                    <div class="row g-3">
                        <!-- Upcoming Bookings (Compact Table) -->
                        <div class="col-md-12">
                            <div class="card-soft">
                                <div class="card-header-soft">
                                    <span>Upcoming Bookings</span>
                                    <a href="#" class="btn btn-xs btn-light rounded-pill">View All</a>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-hover align-middle mb-0">
                                            <thead class="bg-light">
                                                <tr>
                                                    <th class="ps-4">Time</th>
                                                    <th>Service</th>
                                                    <th>User</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($upcomingBookings->take(4) as $booking)
                                                <tr>
                                                    <td class="ps-4">
                                                        <div class="fw-bold fs-7">{{ \Carbon\Carbon::parse($booking->date)->format('M d') }}</div>
                                                        <small class="text-muted">{{ \Carbon\Carbon::parse($booking->time)->format('h:i A') }}</small>
                                                    </td>
                                                    <td><span class="badge bg-light text-dark border">{{ $booking->bookingFor->service ?? 'N/A' }}</span></td>
                                                    <td>{{ $booking->user->name ?? 'Guest' }}</td>
                                                    <td>
                                                         <span class="badge {{ $booking->payment_status == 'paid' ? 'bg-success' : 'bg-warning' }} rounded-pill" style="font-size: 0.7rem;">{{ ucfirst($booking->payment_status) }}</span>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr><td colspan="4" class="text-center py-3 text-muted">No upcoming bookings</td></tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column (Widgets & Secondary Charts) -->
                <div class="col-xl-4 col-lg-5">
                    
                    <!-- Quick Actions Widget -->
                    <div class="card-soft mb-3 p-3">
                        <h6 class="mb-3 fw-bold text-dark">Quick Actions</h6>
                        <div class="row g-2">
                             <div class="col-6">
                                <a href="#" class="btn-quick">
                                    <i class="fa fa-plus-circle text-primary"></i>
                                    <span>New Booking</span>
                                </a>
                            </div>
                             <div class="col-6">
                                <a href="#" class="btn-quick">
                                    <i class="fa fa-users text-info"></i>
                                    <span>Add User</span>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Real-time Venue Status -->
                    <div class="card-soft mb-3">
                        <div class="card-header-soft py-2">
                            <span class="fs-6">Venue Status (Live)</span>
                            <span class="badge bg-danger rounded-pill">Live</span>
                        </div>
                        <div class="card-body p-0 scroll-list">
                            @foreach($venueStatus as $venue)
                            <div class="venue-status-item">
                                <div class="d-flex align-items-center">
                                    <div class="icon-shape me-2" style="width: 32px; height: 32px; font-size: 0.9rem; background: #f9f9f9;">
                                        <i class="fa {{ $venue['icon'] }}"></i>
                                    </div>
                                    <span class="fw-medium text-dark">{{ $venue['name'] }}</span>
                                </div>
                                <div class="d-flex align-items-center">
                                    <span class="status-dot {{ $venue['status'] == 'Occupied' ? 'status-occupied' : 'status-available' }}"></span>
                                    <small class="fw-bold {{ $venue['status'] == 'Occupied' ? 'text-danger' : 'text-success' }}">{{ $venue['status'] }}</small>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Payment Split Donut -->
                    <div class="card-soft mb-3">
                         <div class="card-header-soft py-2">
                            <span class="fs-6">Payment Methods</span>
                        </div>
                        <div class="card-body p-2 d-flex justify-content-center">
                            <div id="paymentChart"></div>
                        </div>
                    </div>

                     <!-- Service Split Donut -->
                     <div class="card-soft mb-3">
                         <div class="card-header-soft py-2">
                            <span class="fs-6">Revenue Sources</span>
                        </div>
                        <div class="card-body p-2 d-flex justify-content-center">
                            <div id="serviceChart"></div>
                        </div>
                    </div>

                </div>
            </div>
            
        </div>
    </div>

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            
            // 1. Revenue Chart (Updated for Soft UI)
            var revenueOptions = {
                series: [{ name: 'Revenue', data: @json(array_values($chartData)) }],
                chart: { height: 280, type: 'area', toolbar: { show: false }, fontFamily: 'Muli, sans-serif' },
                colors: ['#667eea'],
                dataLabels: { enabled: false },
                stroke: { curve: 'smooth', width: 2 },
                fill: { type: 'gradient', gradient: { shadeIntensity: 1, opacityFrom: 0.6, opacityTo: 0.1, stops: [0, 90, 100] } },
                xaxis: { categories: @json(array_values($chartLabels)), axisBorder: { show: false }, axisTicks: { show: false }, labels: { style: { colors: '#9ca3af' } } },
                yaxis: { labels: { style: { colors: '#9ca3af' }, formatter: function (val) { return "$" + val } } },
                grid: { borderColor: '#f3f4f6', strokeDashArray: 4 }
            };
            new ApexCharts(document.querySelector("#revenueChart"), revenueOptions).render();

            // 2. Service Split Chart
            var serviceOptions = {
                series: @json($serviceRevenue),
                labels: @json($serviceLabels),
                chart: { type: 'donut', height: 200, fontFamily: 'Muli, sans-serif' },
                colors: ['#667eea', '#764ba2'],
                dataLabels: { enabled: false },
                legend: { position: 'bottom', fontSize: '12px' },
                plotOptions: { pie: { donut: { size: '70%', labels: { show: true, total: { show: true, showAlways: true, label: 'Total', fontSize: '12px', color: '#6b7280' } } } } }
            };
            new ApexCharts(document.querySelector("#serviceChart"), serviceOptions).render();

            // 3. Payment Method Chart
            var paymentOptions = {
                series: @json($paymentMethodCounts),
                labels: @json($paymentMethodLabels),
                chart: { type: 'pie', height: 200, fontFamily: 'Muli, sans-serif' },
                colors: ['#10b981', '#f59e0b'],
                dataLabels: { enabled: false },
                legend: { position: 'bottom', fontSize: '12px' },
            };
            new ApexCharts(document.querySelector("#paymentChart"), paymentOptions).render();
        });
    </script>
    @endpush

</x-admin.admin-layout>
