<x-user.layout>



    {{-- <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Account Details</h5>
                        <button id="editBtn" class="btn btn-light btn-sm">
                            <i class="ri-edit-2-line"></i> Edit
                        </button>
                    </div>
                    <div class="card-body">
                        <form id="accountForm" method="POST" action="">
                            @csrf
                            @method('PUT')

                            <div class="mb-3">
                                <label class="form-label fw-bold">Full Name</label>
                                <input type="text" class="form-control" name="name" id="name"
                                    value="{{ Auth::user()->name }}" disabled>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">Email</label>
                                <input type="email" class="form-control" name="email" id="email"
                                    value="{{ Auth::user()->email }}" disabled>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">Mobile Number</label>
                                <input type="text" class="form-control" name="mobile" id="mobile"
                                    value="{{ Auth::user()->mobile ?? '' }}" disabled>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">Address</label>
                                <textarea class="form-control" name="address" id="address" rows="3" disabled>{{ Auth::user()->address ?? '' }}</textarea>
                            </div>

                            <div class="text-end">
                                <button type="submit" class="btn btn-success d-none" id="saveBtn">Save
                                    Changes</button>
                                <button type="button" class="btn btn-secondary d-none" id="cancelBtn">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}

    <div class="breadcrumb-area pb-4 bg-peach position-relative z-1">
        <div class="container text-center">
            <h2 class="section-title style-two">My Account</h2>
            <ul class="br-menu list-unstyled mb-0">
                <li><a href="{{ route('home') }}">Home</a></li>
                <li>My Account</li>
            </ul>
        </div>
    </div>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-header bg-light text-white d-flex justify-content-between align-items-center border-3">
                        <h3 class="mb-0">Account Details</h3>
                        <button id="editBtn" class="btn btn-light btn-sm">
                            <i class="ri-edit-2-line"></i> Edit
                        </button>
                    </div>
                    <div class="card-body">
                        <form id="accountForm" method="POST" class="mt-4" action="{{ route('users-detail.update', Auth::user()->id) }}">
                            @csrf
                            @method('PUT')

                            <div class="mb-3 border-2">
                                <label class="form-label fw-bold">Full Name</label>
                                <input type="text" class="form-control" name="name" id="name"
                                    value="{{ Auth::user()->name }}" disabled>
                            </div>

                            <div class="mb-3 border-2">
                                <label class="form-label fw-bold">Email</label>
                                <input type="email" class="form-control" name="email" id="email"
                                    value="{{ Auth::user()->email }}" disabled>
                            </div>

                            <div class="mb-3 border-2">
                                <label class="form-label fw-bold">Mobile Number</label>
                                <input type="text" class="form-control" name="mobile" id="mobile"
                                    value="{{ Auth::user()->mobile ?? '' }}" disabled>
                            </div>

                            <div class="mb-3 border-2">
                                <label class="form-label fw-bold">Address</label>
                                <textarea class="form-control" name="address" id="address" rows="3" disabled>{{ Auth::user()->address ?? '' }}</textarea>
                            </div>

                            <div class="text-end">
                                <button type="submit" class="btn btn-success d-none" id="saveBtn">
                                    Save Changes
                                </button>
                                <button type="button" class="btn btn-secondary d-none" id="cancelBtn">
                                    Cancel
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>



</x-user.layout>


<script>
    $(document).ready(function() {

        // Initially disable all fields and hide buttons
        const $formFields = $("#accountForm").find("input, textarea");
        const $saveBtn = $("#saveBtn");
        const $cancelBtn = $("#cancelBtn");

        // Edit button click
        $("#editBtn").click(function() {
            $formFields.prop("disabled", false);
            $saveBtn.removeClass("d-none");
            $cancelBtn.removeClass("d-none");
            $(this).prop("disabled", true);
        });

        // Cancel button click
        $cancelBtn.click(function() {
            $formFields.prop("disabled", true);
            $saveBtn.addClass("d-none");
            $cancelBtn.addClass("d-none");
            $("#editBtn").prop("disabled", false);
            $("#accountForm")[0].reset(); // Reset form to original values
        });

        // AJAX form submit
        $("#accountForm").submit(function(e) {
            e.preventDefault();

            $.ajax({
                url: $(this).attr("action"),
                type: "POST",
                data: $(this).serialize(),
                beforeSend: function() {
                    $saveBtn.prop("disabled", true);
                },
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Updated!',
                        text: 'Your account details have been updated successfully.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                    $formFields.prop("disabled", true);
                    $saveBtn.addClass("d-none").text("Save Changes").prop("disabled",
                    false);
                    $cancelBtn.addClass("d-none");
                    $("#editBtn").prop("disabled", false);
                },
                error: function(xhr) {
                    let errorMsg = "Something went wrong!";
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMsg = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: errorMsg,
                    });
                    $saveBtn.text("Save Changes").prop("disabled", false);
                }
            });
        });
    });
</script>
