<x-user.layout>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-header bg-warning text-dark text-center py-4">
                        <h4 class="mb-0 fw-bold"><i class="fas fa-sync-alt me-2"></i> Confirm Reschedule Payment</h4>
                    </div>
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <p class="text-muted">Rescheduling {{ count($newTimeSlots) }} slot(s)</p>
                            <h2 class="display-4 fw-bold text-primary">₹{{ number_format($amountToPay, 2) }}</h2>
                            <span class="badge bg-danger-subtle text-danger rounded-pill px-3 py-2 mt-2">Additional
                                Charge</span>
                        </div>

                        <div class="alert alert-light border rounded-3 mb-4">
                            <div class="d-flex justify-content-between mb-2">
                                <small>Previous Booking Value</small>
                                <span class="fw-bold">₹{{ number_format($oldAmount, 2) }}</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <small>New Booking Value</small>
                                <span class="fw-bold">₹{{ number_format($newAmount, 2) }}</span>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between">
                                <small class="fw-bold">New Time Slots</small>
                                <div class="text-end">
                                    @foreach($newTimeSlots as $slot)
                                        <span
                                            class="badge bg-primary-subtle text-primary rounded-pill">{{ \Carbon\Carbon::parse($slot)->format('g:i A') }}</span>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <form action="{{ route('booking.reschedule.confirm') }}" method="POST"
                            id="reschedulePaymentForm">
                            @csrf
                            <input type="hidden" name="group_id" value="{{ $groupId }}">
                            <input type="hidden" name="new_date" value="{{ $newDate }}">
                            <input type="hidden" name="new_time_slots" value="{{ implode(',', $newTimeSlots) }}">
                            <input type="hidden" name="amount_paid" value="{{ $amountToPay }}">
                            <input type="hidden" name="is_group_reschedule"
                                value="{{ $isGroupReschedule ? '1' : '0' }}">

                            <!-- Razorpay Fields -->
                            <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">
                            <input type="hidden" name="razorpay_order_id" id="razorpay_order_id">
                            <input type="hidden" name="razorpay_signature" id="razorpay_signature">

                            <div class="d-grid gap-2">
                                <button type="button" id="payRescheduleBtn"
                                    class="btn btn-primary btn-lg rounded-pill fw-bold shadow-sm">
                                    Pay ₹{{ number_format($amountToPay) }} & Confirm
                                </button>
                                <a href="{{ route('my-booking.show') }}"
                                    class="btn btn-outline-secondary btn-lg rounded-pill">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script>
        document.getElementById('payRescheduleBtn').onclick = function (e) {
            e.preventDefault();

            var paymentEnabled = {{ $paymentEnabled ? 'true' : 'false' }};
            var orderId = "{{ $orderId }}";

            if (!paymentEnabled) {
                // Bypass Mode
                document.getElementById('razorpay_payment_id').value = 'bypass_pay_' + Math.random().toString(36).substr(2, 9);
                document.getElementById('razorpay_order_id').value = orderId;
                document.getElementById('razorpay_signature').value = 'bypass_sig_' + Math.random().toString(36).substr(2, 9);

                // Change button text
                var btn = document.getElementById('payRescheduleBtn');
                btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Processing...';
                btn.disabled = true;

                document.getElementById('reschedulePaymentForm').submit();
                return;
            }

            var options = {
                "key": "{{ config('services.razorpay.key') }}",
                "amount": "{{ $amountToPay * 100 }}",
                "currency": "INR",
                "name": "Turf Reschedule",
                "description": "Additional Charge for Reschedule",
                "image": "{{ asset('user/assets/img/logo/logo.png') }}",
                "order_id": "{{ $orderId }}",
                "handler": function (response) {
                    document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
                    document.getElementById('razorpay_order_id').value = response.razorpay_order_id;
                    document.getElementById('razorpay_signature').value = response.razorpay_signature;

                    document.getElementById('reschedulePaymentForm').submit();
                },
                "prefill": {
                    "name": "{{ auth()->user()->name }}",
                    "email": "{{ auth()->user()->email }}",
                    "contact": "{{ auth()->user()->phone ?? '' }}"
                },
                "theme": {
                    "color": "#ffc107"
                }
            };
            var rzp1 = new Razorpay(options);
            rzp1.open();
        }
    </script>
</x-user.layout>